unit WinForm;

interface

uses
  System.Drawing, System.Collections, System.ComponentModel,
  System.Windows.Forms, System.Data, mwCommandProcessor;

type

  TSampleCmd = class(TmwCommand)
    procedure Execute(Sender: TObject); override;
  end;

  TWinForm = class(System.Windows.Forms.Form)
  {$REGION 'Designer Managed Code'}
  strict private
    /// <summary>
    /// Required designer variable.
    /// </summary>
    Components: System.ComponentModel.Container;
    /// <summary>
    /// Required method for Designer support - do not modify
    /// the contents of this method with the code editor.
    /// </summary>
    procedure InitializeComponent;
  {$ENDREGION}
  strict protected
    Cmd: TmwCommandProcessor;
    /// <summary>
    /// Clean up any resources being used.
    /// </summary>
    procedure Dispose(Disposing: Boolean); override;
    procedure InitializeCommandProcessor;
    procedure OnKeyDown(e: KeyEventArgs); override;
    procedure OnKeyPress(e: KeyPressEventArgs); override;
    procedure OnKeyUp(e: KeyEventArgs); override;
  public
    constructor Create;
  end;

implementation

{ TSampleCmd }

procedure TSampleCmd.Execute(Sender: TObject);
begin
  (Sender as System.Windows.Forms.Form).Text:= Key + '   executed';
end;

{$REGION 'Windows Form Designer generated code'}
/// <summary>
/// Required method for Designer support - do not modify
/// the contents of this method with the code editor.
/// </summary>
procedure TWinForm.InitializeComponent;
begin
  Self.Components := System.ComponentModel.Container.Create;
  Self.Size := System.Drawing.Size.Create(300, 300);
  Self.Text := 'WinForm';
end;
{$ENDREGION}

procedure TWinForm.Dispose(Disposing: Boolean);
begin
  if Disposing then
  begin
    if Components <> nil then
      Components.Dispose();
      Cmd.Free;
  end;
  inherited Dispose(Disposing);
end;

constructor TWinForm.Create;
begin
  inherited Create;
  //
  // Required for Windows Form Designer support
  //
  InitializeComponent;
  //
  // TODO: Add any constructor code after InitializeComponent call
  //
  InitializeCommandProcessor;
end;

procedure TWinForm.InitializeCommandProcessor;
begin
  Cmd:= TmwCommandProcessor.Create;
  Cmd.AddCommand(TSampleCmd.Create('Down'));
  Cmd.AddCommand(TSampleCmd.Create('Up'));
  Cmd.AddCommand(TSampleCmd.Create('Left'));
  Cmd.AddCommand(TSampleCmd.Create('Right'));
  Cmd.AddCommand(TSampleCmd.Create('PageDown'));
  Cmd.AddCommand(TSampleCmd.Create('PageUP'));
  Cmd.AddCommand(TSampleCmd.Create('ControlPageDown'));
  Cmd.AddCommand(TSampleCmd.Create('ControlPageUP'));
  Cmd.AddCommand(TSampleCmd.Create('ControlHome'));
  Cmd.AddCommand(TSampleCmd.Create('ControlEnd'));
  Cmd.AddCommand(TSampleCmd.Create('ShiftAlt1'));
  Cmd.AddCommand(TSampleCmd.Create('ShiftAltC'));
  Cmd.AddCommand(TSampleCmd.Create('ControlAlt1'));
  Cmd.AddCommand(TSampleCmd.Create('ControlShiftK1'));
end;

procedure TWinForm.OnKeyDown(e: KeyEventArgs);
begin
  inherited OnKeyDown(e);
  Cmd.OnKeyDown(Self, e);
end;

procedure TWinForm.OnKeyUp(e: KeyEventArgs);
begin
  inherited OnKeyUp(e);
  Cmd.OnKeyUp(Self, e);
end;

procedure TWinForm.OnKeyPress(e: KeyPressEventArgs);
begin
  inherited OnKeyPress(e);
  Cmd.OnKeyPress(Self, e);
end;

end.
